<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1\Conference;

use Twilio\Options;
use Twilio\Values;

abstract class ConferenceParticipantOptions {
    /**
     * @param string $events Conference events generated by application or
     *                       participant activity.
     * @param string $metrics Object. Contains call quality metrics.
     * @return FetchConferenceParticipantOptions Options builder
     */
    public static function fetch(string $events = Values::NONE, string $metrics = Values::NONE): FetchConferenceParticipantOptions {
        return new FetchConferenceParticipantOptions($events, $metrics);
    }

    /**
     * @param string $participantSid Participant SID.
     * @param string $label User-specified label for a participant.
     * @param string $events Conference events generated by application or
     *                       participant activity.
     * @return ReadConferenceParticipantOptions Options builder
     */
    public static function read(string $participantSid = Values::NONE, string $label = Values::NONE, string $events = Values::NONE): ReadConferenceParticipantOptions {
        return new ReadConferenceParticipantOptions($participantSid, $label, $events);
    }
}

class FetchConferenceParticipantOptions extends Options {
    /**
     * @param string $events Conference events generated by application or
     *                       participant activity.
     * @param string $metrics Object. Contains call quality metrics.
     */
    public function __construct(string $events = Values::NONE, string $metrics = Values::NONE) {
        $this->options['events'] = $events;
        $this->options['metrics'] = $metrics;
    }

    /**
     * Conference events generated by application or participant activity; e.g. `hold`, `mute`, etc.
     *
     * @param string $events Conference events generated by application or
     *                       participant activity.
     * @return $this Fluent Builder
     */
    public function setEvents(string $events): self {
        $this->options['events'] = $events;
        return $this;
    }

    /**
     * Object. Contains participant call quality metrics.
     *
     * @param string $metrics Object. Contains call quality metrics.
     * @return $this Fluent Builder
     */
    public function setMetrics(string $metrics): self {
        $this->options['metrics'] = $metrics;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.FetchConferenceParticipantOptions ' . $options . ']';
    }
}

class ReadConferenceParticipantOptions extends Options {
    /**
     * @param string $participantSid Participant SID.
     * @param string $label User-specified label for a participant.
     * @param string $events Conference events generated by application or
     *                       participant activity.
     */
    public function __construct(string $participantSid = Values::NONE, string $label = Values::NONE, string $events = Values::NONE) {
        $this->options['participantSid'] = $participantSid;
        $this->options['label'] = $label;
        $this->options['events'] = $events;
    }

    /**
     * The unique SID identifier of the Participant.
     *
     * @param string $participantSid Participant SID.
     * @return $this Fluent Builder
     */
    public function setParticipantSid(string $participantSid): self {
        $this->options['participantSid'] = $participantSid;
        return $this;
    }

    /**
     * User-specified label for a participant.
     *
     * @param string $label User-specified label for a participant.
     * @return $this Fluent Builder
     */
    public function setLabel(string $label): self {
        $this->options['label'] = $label;
        return $this;
    }

    /**
     * Conference events generated by application or participant activity; e.g. `hold`, `mute`, etc.
     *
     * @param string $events Conference events generated by application or
     *                       participant activity.
     * @return $this Fluent Builder
     */
    public function setEvents(string $events): self {
        $this->options['events'] = $events;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.ReadConferenceParticipantOptions ' . $options . ']';
    }
}